//precision highp float;

uniform vec4 u_color;
uniform int maskEnabled;
uniform float maskOffset;
uniform vec2 maskScale;
uniform vec2 u_uvSizeBWMask;
uniform vec2 u_uvBWPos;

uniform float u_brightness;

varying vec2 v_texCoord;
varying vec2 v_texCoordMask;
varying vec2 v_BWMaskCoord;


void main()
{
    vec4 color = texture2D(CC_Texture1, v_texCoord);
    vec4 colorOutput = mix(color,vec4(1.0,1.0,1.0,color.a), u_brightness);
    vec4 finalColor;
    vec4 bwMaskOutput;
    vec4 colorMaskOutput;
    float overlay;
    
    if(maskEnabled >0){
        
       vec2 bwScaled = (v_BWMaskCoord +  vec2(maskOffset,0.0)) * maskScale  * u_uvSizeBWMask;
       vec2 bwFinalCoord = u_uvBWPos + mod(bwScaled, u_uvSizeBWMask);
       bwMaskOutput = texture2D(CC_Texture3, bwFinalCoord ) ;
       finalColor.rgba = colorOutput.rgba * bwMaskOutput.a;
        
    }else{
        finalColor = colorOutput ;
    }
    
    if(finalColor.a < 0.1)
        discard;
    gl_FragColor = finalColor * u_color;
}